/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingWorker;

public class PrimesSwingWorker {
    public static void main(String[] args) {
        Main application = new Main();
        application.setDefaultCloseOperation(3);
    }

    public static final class Main
    extends JFrame {
        private final JTextField highestPrimeJTextField = new JTextField();
        private final JButton getPrimesJButton = new JButton("Get Primes");
        private final JTextArea displayPrimesJTextArea = new JTextArea();
        private final JButton cancelJButton = new JButton("Cancel");
        private final JProgressBar progressJProgressBar = new JProgressBar();
        private final JLabel statusJLabel = new JLabel();
        private PrimeCalculator calculator;

        public Main() {
            super("Finding Primes with SwingWorker");
            this.setLayout(new BorderLayout());
            JPanel northJPanel = new JPanel();
            northJPanel.add(new JLabel("Find primes less than: "));
            this.highestPrimeJTextField.setColumns(5);
            northJPanel.add(this.highestPrimeJTextField);
            this.getPrimesJButton.addActionListener(e -> {
                int number;
                this.progressJProgressBar.setValue(0);
                this.displayPrimesJTextArea.setText("");
                this.statusJLabel.setText("");
                try {
                    number = Integer.parseInt(this.highestPrimeJTextField.getText());
                }
                catch (NumberFormatException ex) {
                    this.statusJLabel.setText("Enter an integer.");
                    return;
                }
                this.calculator = new PrimeCalculator(number, this.displayPrimesJTextArea, this.statusJLabel, this.getPrimesJButton, this.cancelJButton);
                this.calculator.addPropertyChangeListener(e1 -> {
                    if (e1.getPropertyName().equals("progress")) {
                        int newValue = (Integer)e1.getNewValue();
                        this.progressJProgressBar.setValue(newValue);
                    }
                });
                this.getPrimesJButton.setEnabled(false);
                this.cancelJButton.setEnabled(true);
                this.calculator.execute();
            });
            northJPanel.add(this.getPrimesJButton);
            this.displayPrimesJTextArea.setEditable(false);
            this.add(new JScrollPane(this.displayPrimesJTextArea, 22, 31));
            JPanel southJPanel = new JPanel(new GridLayout(1, 3, 10, 10));
            this.cancelJButton.setEnabled(false);
            this.cancelJButton.addActionListener(e -> this.calculator.cancel(true));
            southJPanel.add(this.cancelJButton);
            this.progressJProgressBar.setStringPainted(true);
            southJPanel.add(this.progressJProgressBar);
            southJPanel.add(this.statusJLabel);
            this.add((Component)northJPanel, "North");
            this.add((Component)southJPanel, "South");
            this.setSize(350, 300);
            this.setVisible(true);
        }
    }

    static class PrimeCalculator
    extends SwingWorker {
        private final JTextArea intermediateJTextArea;
        private final JButton getPrimesJButton;
        private final JButton cancelJButton;
        private final JLabel statusJLabel;
        private final boolean[] isPrime;

        public PrimeCalculator(int max, JTextArea intermediateJTextArea, JLabel statusJLabel, JButton getPrimesJButton, JButton cancelJButton) {
            this.intermediateJTextArea = intermediateJTextArea;
            this.statusJLabel = statusJLabel;
            this.getPrimesJButton = getPrimesJButton;
            this.cancelJButton = cancelJButton;
            this.isPrime = new boolean[max];
            Arrays.fill(this.isPrime, true);
        }

        public Integer doInBackground() {
            int count = 0;
            for (int i = 2; i < this.isPrime.length; ++i) {
                if (this.isCancelled()) {
                    return count;
                }
                this.setProgress(100 * (i + 1) / this.isPrime.length);
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException ex) {
                    this.statusJLabel.setText("Worker thread interrupted");
                    return count;
                }
                if (!this.isPrime[i]) continue;
                this.publish(i);
                ++count;
                for (int j = 2 * i; j < this.isPrime.length; j += i) {
                    this.isPrime[j] = false;
                }
            }
            return count;
        }

        protected void process(List publishedVals) {
            for (int i = 0; i < publishedVals.size(); ++i) {
                this.intermediateJTextArea.append(publishedVals.get(i) + "\n");
            }
        }

        @Override
        protected void done() {
            this.getPrimesJButton.setEnabled(true);
            this.cancelJButton.setEnabled(false);
            try {
                this.statusJLabel.setText("Found " + this.get() + " primes.");
            }
            catch (InterruptedException | CancellationException | ExecutionException ex) {
                this.statusJLabel.setText(ex.getMessage());
            }
        }
    }
}

